import java.io.*;

public class Main {
  public static void main (String args[]) {
    if(args.length < 1){
      System.out.println("Wywołanie programu: Main nazwa_pliku [numer]");
      return;
    }

    RandomAccessFile raf = null;
    try{
      raf = new RandomAccessFile(args[0], "r");
    }
    catch(FileNotFoundException e){
      System.out.println("Nie ma takiego pliku.");
      return;
    }
    
    int licznik = 1;
    if(args.length == 2){
      try{
        licznik = Integer.parseInt(args[1]);
      }
      catch(NumberFormatException e){
        System.out.println("Nieprawidłowa wartość licznika.");
      }
    }
    
    String line = "";
    try{
      while((line = raf.readLine()) != null){
        System.out.println("["+ licznik +"] " + line);
        licznik++;
      }
      raf.close();
    }
    catch(IOException e){
      System.out.println("Błąd wejścia-wyjścia.");
    }
  }
}
